--
-- DrivingParticleSystem
-- Specialization for DrivingParticleSystem
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		13/11/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

DrivingParticleSystem = {};

function DrivingParticleSystem.prerequisitesPresent(specializations)
    return true;
end;

function DrivingParticleSystem:load(xmlFile)
	
    self.drivingParticles = {};
    if self.isClient then
        local i=0;
        while true do
            local key = string.format("vehicle.drivingParticles.drivingParticle(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end;
            local particle = {};
            particle.ps = {};
            Utils.loadParticleSystem(xmlFile, particle.ps, key, self.components, false, nil, self.baseDirectory);
            if table.getn(particle.ps) > 0 then
                particle.minSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minSpeed"), 2)/3600;
                particle.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSpeed"), 40)/3600;
                particle.minScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minScale"), 0.2);
                particle.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxScale"), 1);
                particle.direction = Utils.getNoNil(getXMLFloat(xmlFile, key.."#direction"), 1);
				particle.wheel = getXMLInt(xmlFile, key .. "#wheel");
				particle.lastScale = 0;
                table.insert(self.drivingParticles, particle);
            end;

            i = i+1;
        end;
    end;
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);
end;

function DrivingParticleSystem:delete()
    for _, particle in pairs(self.drivingParticles) do
        Utils.deleteParticleSystem(particle.ps);
    end;
end;

function DrivingParticleSystem:readStream(streamId, connection)
end;

function DrivingParticleSystem:writeStream(streamId, connection)
end;

function DrivingParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DrivingParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function DrivingParticleSystem:update(dt)
end;

function DrivingParticleSystem:updateTick(dt)	

	if self.isClient then	
		if self:getIsActive() then
            for k, particle in pairs(self.drivingParticles) do		
				local isActive = false;
				
				if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
					if particle.wheel ~= nil then
						local x,y,z = getWorldTranslation(self.wheels[particle.wheel].repr);--getWheelShapeContactPoint(self.wheels[particle.wheel].node, self.wheels[particle.wheel].wheelShape);
						y = y - self.wheels[particle.wheel].radius;
						
						if y ~= nil then
							local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z); 
							local hasGroundContact = math.abs(y - height) < self.drivingParticleThreshold;
							
							if self.lastSpeedReal > particle.minSpeed and (particle.direction == 0 or (particle.direction > 0) == (self.movingDirection > 0)) and hasGroundContact then								
								isActive = true;
							end;
						end;
					end;
				end;
				Utils.setEmittingState(particle.ps, isActive);
            end;
		else
			for _, particle in pairs(self.drivingParticles) do
				Utils.setEmittingState(particle.ps, false);
			end;
        end;
    end;
end;

function DrivingParticleSystem:draw()	
end;