--
-- FruitParticleSystem
-- Specialization for FruitParticleSystem
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/09/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--
-- Edit to FruitParticleSystemSunflowerHaecksler by Ifko[nator] am 10.05.2014
-- Dieses Script funktioniert nun für Häckslerschneidwerke! Und nur bei der Frucht 'Sonnenblume'!

FruitParticleSystemSunflowerHaecksler = {};

function FruitParticleSystemSunflowerHaecksler.prerequisitesPresent(specializations)
    return true;
end;

function FruitParticleSystemSunflowerHaecksler:load(xmlFile)
	
	self.canPlaceParticle = FruitParticleSystemSunflowerHaecksler.canPlaceParticle;
	self.getIsPSActive = FruitParticleSystemSunflowerHaecksler.getIsPSActive;
	self.resetFruitParticleSystemSunflowerHaecksler = FruitParticleSystemSunflowerHaecksler.resetFruitParticleSystemSunflowerHaecksler;
	
	self.fruitParticleSunflower = {};
	self.fruitParticleSunflower.leftFreePart = {};
	self.fruitParticleSunflower.rightFreePart = {};
	
	self.fruitParticleSunflower.cloneFactor = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.FruitParticleSystemSunflowerHaecksler.fruits#cloneFactor"), 5);
	i = 0;
	while true do		
		local key = string.format("vehicle.FruitParticleSystemSunflowerHaecksler.fruits.fruit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local fruitType = getXMLString(xmlFile, key .. "#type");
		self.fruitParticleSunflower.leftFreePart[fruitType] = {};
		self.fruitParticleSunflower.rightFreePart[fruitType] = {};
		
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"));
		local rightNode = clone(node, true);
		setVisibility(rightNode, false);
		setVisibility(node, false);
		table.insert(self.fruitParticleSunflower.leftFreePart[fruitType], node);
		table.insert(self.fruitParticleSunflower.rightFreePart[fruitType], rightNode);
		
		for j=1, self.fruitParticleSunflower.cloneFactor*4 do
			local fruitLeftClone = clone(node, true);
			local fruitRightClone = clone(node, true);
			setVisibility(fruitLeftClone, false);
			setVisibility(fruitRightClone, false);
			table.insert(self.fruitParticleSunflower.leftFreePart[fruitType], fruitLeftClone);
			table.insert(self.fruitParticleSunflower.rightFreePart[fruitType], fruitRightClone);
		end;			
		i = i + 1;
	end;
	
	local leftAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemSunflowerHaecksler.left.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(leftAreas, area);
		i = i + 1;
	end;
	self.fruitParticleSunflower.leftAreas = leftAreas;
	
	
	local rightAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemSunflowerHaecksler.right.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(rightAreas, area);
		i = i + 1;
	end;
	self.fruitParticleSunflower.rightAreas = rightAreas;
	
	local leftAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemSunflowerHaecksler.animations.left.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		leftAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleSunflower.leftAnimation = leftAnimation;
	
	local rightAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemSunflowerHaecksler.animations.right.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		rightAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleSunflower.rightAnimation = rightAnimation;	
	self.fruitParticleSunflower.speed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSunflowerHaecksler.animations#speed"), 11);
	self.fruitParticleSunflower.animTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSunflowerHaecksler.animations#time"), 3) * 1000;
	local fruitTime = getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSunflowerHaecksler.fruits#fruitOffset");
	if fruitTime ~= nil then
		self.fruitParticleSunflower.partCount = fruitTime*1000;
	end;	
	
	self.fruitParticleSunflower.leftPartInAnim = {};
	self.fruitParticleSunflower.rightPartInAnim = {};
	
	self.sunflowerFruit = FruitUtil.FRUITTYPE_SUNFLOWER;
	self.isFruitReset = false;
	
	local mapObj = g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT];
	self.wheatViewDistance = getFoliageViewDistance(mapObj.id);
	
	self.onStopDoReset = false;
end;

function FruitParticleSystemSunflowerHaecksler:delete()
end;

function FruitParticleSystemSunflowerHaecksler:readStream(streamId, connection)
end;

function FruitParticleSystemSunflowerHaecksler:writeStream(streamId, connection)
end;

function FruitParticleSystemSunflowerHaecksler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FruitParticleSystemSunflowerHaecksler:keyEvent(unicode, sym, modifier, isDown)
end;

function FruitParticleSystemSunflowerHaecksler:update(dt)
end;

function FruitParticleSystemSunflowerHaecksler:updateTick(dt)	
	
	if self.rollNodes[1].speed ~= 0 then
		-- play particle animation		
		local animTime = self.fruitParticleSunflower.animTime;
		for k, particle in pairs(self.fruitParticleSunflower.leftPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleSunflower.leftPartInAnim, k);
				table.insert(self.fruitParticleSunflower.leftFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSunflower.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSunflower.leftAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		for k, particle in pairs(self.fruitParticleSunflower.rightPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleSunflower.rightPartInAnim, k);
				table.insert(self.fruitParticleSunflower.rightFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSunflower.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSunflower.rightAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		self.onStopDoReset = true;
	else
		if self.onStopDoReset then
			self:resetFruitParticleSystemSunflowerHaecksler();
			self.onStopDoReset = false;
		end;
	end;

	if self:getIsActive() then			
		local camera = getCamera();
		local distance = 0;
		if camera ~= 0 then
			local x,y,z = getWorldTranslation(camera);
			local x1,y1,z1 = getWorldTranslation(self.rootNode);
			distance = Utils.vector3Length(x-x1,y-y1,z-z1);
		end;
		
		local allowsThreshing = true;
		if self.attacherVehicle ~= nil then
			allowsThreshing = self.attacherVehicle.allowsThreshing and self.attacherVehicle:getIsThreshingAllowed(false);
		end;
		
		if self.reelStarted and self:getIsPSActive() and self.lastSpeed*3600 > 0.5 and self.speedViolationTimer > 0 and allowsThreshing and distance < self.wheatViewDistance then
			if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing then
				for k, area in pairs(self.fruitParticleSunflower.leftAreas) do
					local x,_,z = getWorldTranslation(area.start);
					local x1,_,z1 = getWorldTranslation(area.width);
					local x2,_,z2 = getWorldTranslation(area.height);  				
					local fruitValue = Utils.getFruitArea(self.sunflowerFruit, x, z, x1, z1, x2, z2);
					if fruitValue > 0 then
						local fruitSunflower = FruitUtil.fruitIndexToDesc[self.sunflowerFruit].name;
						if table.getn(self.fruitParticleSunflower.leftFreePart[fruitSunflower]) > 0 then
							local startTime = self.fruitParticleSunflower.animTime * ((table.getn(self.fruitParticleSunflower.leftAreas) - k) / table.getn(self.fruitParticleSunflower.leftAreas));
							if self:canPlaceParticle(self.fruitParticleSunflower.leftPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleSunflower.leftFreePart[fruitSunflower][1];	
								newParticle.type = fruitSunflower;						
								table.remove(self.fruitParticleSunflower.leftFreePart[fruitSunflower], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSunflower.leftAnimation:get(newParticle.time / self.fruitParticleSunflower.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleSunflower.leftPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
				
				for k, area in pairs(self.fruitParticleSunflower.rightAreas) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);  		
					local fruitValue = Utils.getFruitArea(self.sunflowerFruit, x, z, x1, z1, x2, z2);
					
					if fruitValue > 0 then
						local fruitSunflower =  FruitUtil.fruitIndexToDesc[self.sunflowerFruit].name;
						if table.getn(self.fruitParticleSunflower.rightFreePart[fruitSunflower]) > 0 then
							local startTime = self.fruitParticleSunflower.animTime * ((table.getn(self.fruitParticleSunflower.rightAreas) - k) / table.getn(self.fruitParticleSunflower.rightAreas));
							if self:canPlaceParticle(self.fruitParticleSunflower.rightPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleSunflower.rightFreePart[fruitSunflower][1];	
								newParticle.type = fruitSunflower;
								table.remove(self.fruitParticleSunflower.rightFreePart[fruitSunflower], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSunflower.rightAnimation:get(newParticle.time / self.fruitParticleSunflower.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleSunflower.rightPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function FruitParticleSystemSunflowerHaecksler:draw()	
end;

function FruitParticleSystemSunflowerHaecksler:resetFruitType()
	self.isFruitReset = true;
end;

function FruitParticleSystemSunflowerHaecksler:getIsPSActive()
	local isActive = self.lastCutterAreaBiggerZero or self.isFruitReset;
	self.isFruitReset = false;	
	return isActive;
end;

function FruitParticleSystemSunflowerHaecksler:canPlaceParticle(animatedParticle, time)	
	local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSunflower.speed, 1.5));
	local halfTime = (self.fruitParticleSunflower.partCount / percent) / 2;
	
	for _, particle in pairs(animatedParticle) do
		if particle.time + halfTime > time and  particle.time - halfTime < time then
			return false;
		end;
	end;
	
	return true;
end;

function FruitParticleSystemSunflowerHaecksler:onLeave()
    if self.deactivateOnLeave then
        self:resetFruitParticleSystemSunflowerHaecksler();
    end;
end;

function FruitParticleSystemSunflowerHaecksler:onDetach()
	self:resetFruitParticleSystemSunflowerHaecksler();
end;

function FruitParticleSystemSunflowerHaecksler:resetFruitParticleSystemSunflowerHaecksler()
	for k, particle in pairs(self.fruitParticleSunflower.leftPartInAnim) do
		table.insert(self.fruitParticleSunflower.leftFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleSunflower.leftPartInAnim = {};
	for k, particle in pairs(self.fruitParticleSunflower.rightPartInAnim) do
		table.insert(self.fruitParticleSunflower.rightFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleSunflower.rightPartInAnim = {};
end;