--
-- FruitParticleSystem
-- Specialization for FruitParticleSystem
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/09/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--
-- Edit to FruitParticleSystemMaizeHaecksler by Ifko[nator] am 10.05.2014
-- Dieses Script funktioniert nun für Häckslerschneidwerke! Und nur bei der Frucht 'Mais'!

FruitParticleSystemMaizeHaecksler = {};

function FruitParticleSystemMaizeHaecksler.prerequisitesPresent(specializations)
    return true;
end;

function FruitParticleSystemMaizeHaecksler:load(xmlFile)
	
	self.canPlaceParticle = FruitParticleSystemMaizeHaecksler.canPlaceParticle;
	self.getIsPSActive = FruitParticleSystemMaizeHaecksler.getIsPSActive;
	self.resetFruitParticleSystemMaizeHaecksler = FruitParticleSystemMaizeHaecksler.resetFruitParticleSystemMaizeHaecksler;
	
	self.fruitParticleMaize = {};
	self.fruitParticleMaize.leftFreePart = {};
	self.fruitParticleMaize.rightFreePart = {};
	
	self.fruitParticleMaize.cloneFactor = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.FruitParticleSystemMaizeHaecksler.fruits#cloneFactor"), 5);
	i = 0;
	while true do		
		local key = string.format("vehicle.FruitParticleSystemMaizeHaecksler.fruits.fruit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local fruitType = getXMLString(xmlFile, key .. "#type");
		self.fruitParticleMaize.leftFreePart[fruitType] = {};
		self.fruitParticleMaize.rightFreePart[fruitType] = {};
		
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"));
		local rightNode = clone(node, true);
		setVisibility(rightNode, false);
		setVisibility(node, false);
		table.insert(self.fruitParticleMaize.leftFreePart[fruitType], node);
		table.insert(self.fruitParticleMaize.rightFreePart[fruitType], rightNode);
		
		for j=1, self.fruitParticleMaize.cloneFactor*4 do
			local fruitLeftClone = clone(node, true);
			local fruitRightClone = clone(node, true);
			setVisibility(fruitLeftClone, false);
			setVisibility(fruitRightClone, false);
			table.insert(self.fruitParticleMaize.leftFreePart[fruitType], fruitLeftClone);
			table.insert(self.fruitParticleMaize.rightFreePart[fruitType], fruitRightClone);
		end;			
		i = i + 1;
	end;
	
	local leftAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemMaizeHaecksler.left.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(leftAreas, area);
		i = i + 1;
	end;
	self.fruitParticleMaize.leftAreas = leftAreas;
	
	
	local rightAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemMaizeHaecksler.right.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(rightAreas, area);
		i = i + 1;
	end;
	self.fruitParticleMaize.rightAreas = rightAreas;
	
	local leftAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemMaizeHaecksler.animations.left.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		leftAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleMaize.leftAnimation = leftAnimation;
	
	local rightAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemMaizeHaecksler.animations.right.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		rightAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleMaize.rightAnimation = rightAnimation;	
	self.fruitParticleMaize.speed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemMaizeHaecksler.animations#speed"), 11);
	self.fruitParticleMaize.animTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemMaizeHaecksler.animations#time"), 3) * 1000;
	local fruitTime = getXMLFloat(xmlFile, "vehicle.FruitParticleSystemMaizeHaecksler.fruits#fruitOffset");
	if fruitTime ~= nil then
		self.fruitParticleMaize.partCount = fruitTime*1000;
	end;	
	
	self.fruitParticleMaize.leftPartInAnim = {};
	self.fruitParticleMaize.rightPartInAnim = {};
	
	self.maizeFruit = FruitUtil.FRUITTYPE_MAIZE;
	self.isFruitReset = false;
	
	local mapObj = g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT];
	self.wheatViewDistance = getFoliageViewDistance(mapObj.id);
	
	self.onStopDoReset = false;
end;

function FruitParticleSystemMaizeHaecksler:delete()
end;

function FruitParticleSystemMaizeHaecksler:readStream(streamId, connection)
end;

function FruitParticleSystemMaizeHaecksler:writeStream(streamId, connection)
end;

function FruitParticleSystemMaizeHaecksler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FruitParticleSystemMaizeHaecksler:keyEvent(unicode, sym, modifier, isDown)
end;

function FruitParticleSystemMaizeHaecksler:update(dt)
end;

function FruitParticleSystemMaizeHaecksler:updateTick(dt)	
	
	if self.rollNodes[1].speed ~= 0 then
		-- play particle animation		
		local animTime = self.fruitParticleMaize.animTime;
		for k, particle in pairs(self.fruitParticleMaize.leftPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleMaize.leftPartInAnim, k);
				table.insert(self.fruitParticleMaize.leftFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleMaize.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleMaize.leftAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		for k, particle in pairs(self.fruitParticleMaize.rightPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleMaize.rightPartInAnim, k);
				table.insert(self.fruitParticleMaize.rightFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleMaize.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleMaize.rightAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		self.onStopDoReset = true;
	else
		if self.onStopDoReset then
			self:resetFruitParticleSystemMaizeHaecksler();
			self.onStopDoReset = false;
		end;
	end;

	if self:getIsActive() then			
		local camera = getCamera();
		local distance = 0;
		if camera ~= 0 then
			local x,y,z = getWorldTranslation(camera);
			local x1,y1,z1 = getWorldTranslation(self.rootNode);
			distance = Utils.vector3Length(x-x1,y-y1,z-z1);
		end;
		
		local allowsThreshing = true;
		if self.attacherVehicle ~= nil then
			allowsThreshing = self.attacherVehicle.allowsThreshing and self.attacherVehicle:getIsThreshingAllowed(false);
		end;
		
		if self.reelStarted and self:getIsPSActive() and self.lastSpeed*3600 > 0.5 and self.speedViolationTimer > 0 and allowsThreshing and distance < self.wheatViewDistance then
			if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing then
				for k, area in pairs(self.fruitParticleMaize.leftAreas) do
					local x,_,z = getWorldTranslation(area.start);
					local x1,_,z1 = getWorldTranslation(area.width);
					local x2,_,z2 = getWorldTranslation(area.height);  				
					local fruitValue = Utils.getFruitArea(self.maizeFruit, x, z, x1, z1, x2, z2);
					if fruitValue > 0 then
						local fruitMaize = FruitUtil.fruitIndexToDesc[self.maizeFruit].name;
						if table.getn(self.fruitParticleMaize.leftFreePart[fruitMaize]) > 0 then
							local startTime = self.fruitParticleMaize.animTime * ((table.getn(self.fruitParticleMaize.leftAreas) - k) / table.getn(self.fruitParticleMaize.leftAreas));
							if self:canPlaceParticle(self.fruitParticleMaize.leftPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleMaize.leftFreePart[fruitMaize][1];	
								newParticle.type = fruitMaize;						
								table.remove(self.fruitParticleMaize.leftFreePart[fruitMaize], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleMaize.leftAnimation:get(newParticle.time / self.fruitParticleMaize.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleMaize.leftPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
				
				for k, area in pairs(self.fruitParticleMaize.rightAreas) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);  		
					local fruitValue = Utils.getFruitArea(self.maizeFruit, x, z, x1, z1, x2, z2);
					
					if fruitValue > 0 then
						local fruitMaize =  FruitUtil.fruitIndexToDesc[self.maizeFruit].name;
						if table.getn(self.fruitParticleMaize.rightFreePart[fruitMaize]) > 0 then
							local startTime = self.fruitParticleMaize.animTime * ((table.getn(self.fruitParticleMaize.rightAreas) - k) / table.getn(self.fruitParticleMaize.rightAreas));
							if self:canPlaceParticle(self.fruitParticleMaize.rightPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleMaize.rightFreePart[fruitMaize][1];	
								newParticle.type = fruitMaize;
								table.remove(self.fruitParticleMaize.rightFreePart[fruitMaize], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleMaize.rightAnimation:get(newParticle.time / self.fruitParticleMaize.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleMaize.rightPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function FruitParticleSystemMaizeHaecksler:draw()	
end;

function FruitParticleSystemMaizeHaecksler:resetFruitType()
	self.isFruitReset = true;
end;

function FruitParticleSystemMaizeHaecksler:getIsPSActive()
	local isActive = self.lastCutterAreaBiggerZero or self.isFruitReset;
	self.isFruitReset = false;	
	return isActive;
end;

function FruitParticleSystemMaizeHaecksler:canPlaceParticle(animatedParticle, time)	
	local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleMaize.speed, 1.5));
	local halfTime = (self.fruitParticleMaize.partCount / percent) / 2;
	
	for _, particle in pairs(animatedParticle) do
		if particle.time + halfTime > time and  particle.time - halfTime < time then
			return false;
		end;
	end;
	
	return true;
end;

function FruitParticleSystemMaizeHaecksler:onLeave()
    if self.deactivateOnLeave then
        self:resetFruitParticleSystemMaizeHaecksler();
    end;
end;

function FruitParticleSystemMaizeHaecksler:onDetach()
	self:resetFruitParticleSystemMaizeHaecksler();
end;

function FruitParticleSystemMaizeHaecksler:resetFruitParticleSystemMaizeHaecksler()
	for k, particle in pairs(self.fruitParticleMaize.leftPartInAnim) do
		table.insert(self.fruitParticleMaize.leftFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleMaize.leftPartInAnim = {};
	for k, particle in pairs(self.fruitParticleMaize.rightPartInAnim) do
		table.insert(self.fruitParticleMaize.rightFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleMaize.rightPartInAnim = {};
end;