--
-- FruitParticleSystem
-- Specialization for FruitParticleSystem
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/09/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--
-- Edit to FruitParticleSystemSudangrassHaecksler by Ifko[nator] am 10.05.2014
-- Dieses Script funktioniert nun für Häckslerschneidwerke! Und nur bei der Frucht 'Sudangras'!

FruitParticleSystemSudangrassHaecksler = {};

function FruitParticleSystemSudangrassHaecksler.prerequisitesPresent(specializations)
    return true;
end;

function FruitParticleSystemSudangrassHaecksler:load(xmlFile)
	
	self.canPlaceParticle = FruitParticleSystemSudangrassHaecksler.canPlaceParticle;
	self.getIsPSActive = FruitParticleSystemSudangrassHaecksler.getIsPSActive;
	self.resetFruitParticleSystemSudangrassHaecksler = FruitParticleSystemSudangrassHaecksler.resetFruitParticleSystemSudangrassHaecksler;
	
	self.fruitParticleSudangrass = {};
	self.fruitParticleSudangrass.leftFreePart = {};
	self.fruitParticleSudangrass.rightFreePart = {};
	
	self.fruitParticleSudangrass.cloneFactor = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.FruitParticleSystemSudangrassHaecksler.fruits#cloneFactor"), 5);
	i = 0;
	while true do		
		local key = string.format("vehicle.FruitParticleSystemSudangrassHaecksler.fruits.fruit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local fruitType = getXMLString(xmlFile, key .. "#type");
		self.fruitParticleSudangrass.leftFreePart[fruitType] = {};
		self.fruitParticleSudangrass.rightFreePart[fruitType] = {};
		
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"));
		local rightNode = clone(node, true);
		setVisibility(rightNode, false);
		setVisibility(node, false);
		table.insert(self.fruitParticleSudangrass.leftFreePart[fruitType], node);
		table.insert(self.fruitParticleSudangrass.rightFreePart[fruitType], rightNode);
		
		for j=1, self.fruitParticleSudangrass.cloneFactor*4 do
			local fruitLeftClone = clone(node, true);
			local fruitRightClone = clone(node, true);
			setVisibility(fruitLeftClone, false);
			setVisibility(fruitRightClone, false);
			table.insert(self.fruitParticleSudangrass.leftFreePart[fruitType], fruitLeftClone);
			table.insert(self.fruitParticleSudangrass.rightFreePart[fruitType], fruitRightClone);
		end;			
		i = i + 1;
	end;
	
	local leftAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemSudangrassHaecksler.left.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(leftAreas, area);
		i = i + 1;
	end;
	self.fruitParticleSudangrass.leftAreas = leftAreas;
	
	
	local rightAreas = {};
	i = 0;
	while true do
		local key = string.format("vehicle.FruitParticleSystemSudangrassHaecksler.right.area(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;		
		local area = {};
		area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#start"));
		area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#width"));
		area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#height"));
		table.insert(rightAreas, area);
		i = i + 1;
	end;
	self.fruitParticleSudangrass.rightAreas = rightAreas;
	
	local leftAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemSudangrassHaecksler.animations.left.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		leftAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleSudangrass.leftAnimation = leftAnimation;
	
	local rightAnimation = AnimCurve:new(linearInterpolatorTransRotScale);
	i = 0;
	while true do 
		local key = string.format("vehicle.FruitParticleSystemSudangrassHaecksler.animations.right.key(%d)", i);
		local t = getXMLFloat(xmlFile, key.."#time");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#translation"));
		if x == nil or y == nil or z == nil then
			break;
		end;
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		rx = math.rad(Utils.getNoNil(rx, 0));
		ry = math.rad(Utils.getNoNil(ry, 0));
		rz = math.rad(Utils.getNoNil(rz, 0));
		local sx, sy, sz= Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		sx = Utils.getNoNil(sx, 1);
		sy = Utils.getNoNil(sy, 1);
		sz = Utils.getNoNil(sz, 1);
		rightAnimation:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = t});
		i = i +1;
	end;
	self.fruitParticleSudangrass.rightAnimation = rightAnimation;	
	self.fruitParticleSudangrass.speed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSudangrassHaecksler.animations#speed"), 11);
	self.fruitParticleSudangrass.animTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSudangrassHaecksler.animations#time"), 3) * 1000;
	local fruitTime = getXMLFloat(xmlFile, "vehicle.FruitParticleSystemSudangrassHaecksler.fruits#fruitOffset");
	if fruitTime ~= nil then
		self.fruitParticleSudangrass.partCount = fruitTime*1000;
	end;	
	
	self.fruitParticleSudangrass.leftPartInAnim = {};
	self.fruitParticleSudangrass.rightPartInAnim = {};
	
	self.sudangrassFruit = FruitUtil.FRUITTYPE_SUDANGRASS;
	self.isFruitReset = false;
	
	local mapObj = g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT];
	self.wheatViewDistance = getFoliageViewDistance(mapObj.id);
	
	self.onStopDoReset = false;
end;

function FruitParticleSystemSudangrassHaecksler:delete()
end;

function FruitParticleSystemSudangrassHaecksler:readStream(streamId, connection)
end;

function FruitParticleSystemSudangrassHaecksler:writeStream(streamId, connection)
end;

function FruitParticleSystemSudangrassHaecksler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FruitParticleSystemSudangrassHaecksler:keyEvent(unicode, sym, modifier, isDown)
end;

function FruitParticleSystemSudangrassHaecksler:update(dt)
end;

function FruitParticleSystemSudangrassHaecksler:updateTick(dt)	
	
	if self.rollNodes[1].speed ~= 0 then
		-- play particle animation		
		local animTime = self.fruitParticleSudangrass.animTime;
		for k, particle in pairs(self.fruitParticleSudangrass.leftPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleSudangrass.leftPartInAnim, k);
				table.insert(self.fruitParticleSudangrass.leftFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSudangrass.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSudangrass.leftAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		for k, particle in pairs(self.fruitParticleSudangrass.rightPartInAnim) do
			if particle.time > animTime then
				table.remove(self.fruitParticleSudangrass.rightPartInAnim, k);
				table.insert(self.fruitParticleSudangrass.rightFreePart[particle.type], particle.node);
				setVisibility(particle.node, false);
			else
				particle.time = particle.time + dt * math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSudangrass.speed, 1.5));
				local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSudangrass.rightAnimation:get(particle.time / animTime);
				setTranslation(particle.node, x,y,z);
				setRotation(particle.node, rx,ry,rz);
				setScale(particle.node, sx,sy,sz);
			end;
		end;
		self.onStopDoReset = true;
	else
		if self.onStopDoReset then
			self:resetFruitParticleSystemSudangrassHaecksler();
			self.onStopDoReset = false;
		end;
	end;

	if self:getIsActive() then			
		local camera = getCamera();
		local distance = 0;
		if camera ~= 0 then
			local x,y,z = getWorldTranslation(camera);
			local x1,y1,z1 = getWorldTranslation(self.rootNode);
			distance = Utils.vector3Length(x-x1,y-y1,z-z1);
		end;
		
		local allowsThreshing = true;
		if self.attacherVehicle ~= nil then
			allowsThreshing = self.attacherVehicle.allowsThreshing and self.attacherVehicle:getIsThreshingAllowed(false);
		end;
		
		if self.reelStarted and self:getIsPSActive() and self.lastSpeed*3600 > 0.5 and self.speedViolationTimer > 0 and allowsThreshing and distance < self.wheatViewDistance then
			if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing then
				for k, area in pairs(self.fruitParticleSudangrass.leftAreas) do
					local x,_,z = getWorldTranslation(area.start);
					local x1,_,z1 = getWorldTranslation(area.width);
					local x2,_,z2 = getWorldTranslation(area.height);  				
					local fruitValue = Utils.getFruitArea(self.sudangrassFruit, x, z, x1, z1, x2, z2);
					if fruitValue > 0 then
						local fruitSudangrass = FruitUtil.fruitIndexToDesc[self.sudangrassFruit].name;
						if table.getn(self.fruitParticleSudangrass.leftFreePart[fruitSudangrass]) > 0 then
							local startTime = self.fruitParticleSudangrass.animTime * ((table.getn(self.fruitParticleSudangrass.leftAreas) - k) / table.getn(self.fruitParticleSudangrass.leftAreas));
							if self:canPlaceParticle(self.fruitParticleSudangrass.leftPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleSudangrass.leftFreePart[fruitSudangrass][1];	
								newParticle.type = fruitSudangrass;						
								table.remove(self.fruitParticleSudangrass.leftFreePart[fruitSudangrass], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSudangrass.leftAnimation:get(newParticle.time / self.fruitParticleSudangrass.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleSudangrass.leftPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
				
				for k, area in pairs(self.fruitParticleSudangrass.rightAreas) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);  		
					local fruitValue = Utils.getFruitArea(self.sudangrassFruit, x, z, x1, z1, x2, z2);
					
					if fruitValue > 0 then
						local fruitSudangrass =  FruitUtil.fruitIndexToDesc[self.sudangrassFruit].name;
						if table.getn(self.fruitParticleSudangrass.rightFreePart[fruitSudangrass]) > 0 then
							local startTime = self.fruitParticleSudangrass.animTime * ((table.getn(self.fruitParticleSudangrass.rightAreas) - k) / table.getn(self.fruitParticleSudangrass.rightAreas));
							if self:canPlaceParticle(self.fruitParticleSudangrass.rightPartInAnim, startTime) then
								local newParticle = {};
								newParticle.time = startTime;
								newParticle.node = self.fruitParticleSudangrass.rightFreePart[fruitSudangrass][1];	
								newParticle.type = fruitSudangrass;
								table.remove(self.fruitParticleSudangrass.rightFreePart[fruitSudangrass], 1);
								-- randomize particle rotation
								setRotation(getChildAt(newParticle.node, 0), math.rad(math.random(-10, 10)), math.rad(math.random(0, 45)), math.rad(math.random(-10, 10)));
								-- set correct particle position
								local x,y,z, rx,ry,rz, sx,sy,sz = self.fruitParticleSudangrass.rightAnimation:get(newParticle.time / self.fruitParticleSudangrass.animTime);
								setTranslation(newParticle.node, x,y,z);
								setRotation(newParticle.node, rx,ry,rz);
								setScale(newParticle.node, sx,sy,sz);
								setVisibility(newParticle.node, true);				
								table.insert(self.fruitParticleSudangrass.rightPartInAnim, newParticle);
							end;
						else
							break;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function FruitParticleSystemSudangrassHaecksler:draw()	
end;

function FruitParticleSystemSudangrassHaecksler:resetFruitType()
	self.isFruitReset = true;
end;

function FruitParticleSystemSudangrassHaecksler:getIsPSActive()
	local isActive = self.lastCutterAreaBiggerZero or self.isFruitReset;
	self.isFruitReset = false;	
	return isActive;
end;

function FruitParticleSystemSudangrassHaecksler:canPlaceParticle(animatedParticle, time)	
	local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.fruitParticleSudangrass.speed, 1.5));
	local halfTime = (self.fruitParticleSudangrass.partCount / percent) / 2;
	
	for _, particle in pairs(animatedParticle) do
		if particle.time + halfTime > time and  particle.time - halfTime < time then
			return false;
		end;
	end;
	
	return true;
end;

function FruitParticleSystemSudangrassHaecksler:onLeave()
    if self.deactivateOnLeave then
        self:resetFruitParticleSystemSudangrassHaecksler();
    end;
end;

function FruitParticleSystemSudangrassHaecksler:onDetach()
	self:resetFruitParticleSystemSudangrassHaecksler();
end;

function FruitParticleSystemSudangrassHaecksler:resetFruitParticleSystemSudangrassHaecksler()
	for k, particle in pairs(self.fruitParticleSudangrass.leftPartInAnim) do
		table.insert(self.fruitParticleSudangrass.leftFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleSudangrass.leftPartInAnim = {};
	for k, particle in pairs(self.fruitParticleSudangrass.rightPartInAnim) do
		table.insert(self.fruitParticleSudangrass.rightFreePart[particle.type], particle.node);
		setVisibility(particle.node, false);
	end;
	self.fruitParticleSudangrass.rightPartInAnim = {};
end;