--
-- Addon for moveable Farmerarm
--
-- @author Aranea
-- @date 01/02/2013
--
-- Edit by Ifko[nator] am 17.02.2014
-- bodyNode hinzugefügt und beide nodes in ein neues XML Tag gesetzt, da der characterNode Tag nun aus der XML raus muss, damit der auch der gesamte Körper sichtbar ist, wenn man im Schlepper sitzt. 

-- Fix am: 15.06.2014
-- Gefixt wurde: Fahrzeuge mit dieser lua lassen sich nun zurücksetzten.
-- Gefixt von Ifko[nator]

FarmerArm = {};

function FarmerArm.prerequisitesPresent(specializations)
	return true;
end;

function FarmerArm:load(xmlFile)
	self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Farmer#armIndex"));
	self.bodyNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Farmer#bodyIndex"));
end;

function FarmerArm:postLoad(xmlFile)
	if self.armNode ~= nil and self.bodyNode ~=nil then
		setVisibility(self.armNode, false);
		setVisibility(self.bodyNode, false);
	end;
end;

function FarmerArm:delete()
end;

function FarmerArm:readStream(streamId, connection)
end;

function FarmerArm:writeStream(streamId, connection)
end;

function FarmerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FarmerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function FarmerArm:update(dt)
end;

function FarmerArm:updateTick(dt)
end;

function FarmerArm:draw()
end;

function FarmerArm:onEnter()
	if self.armNode ~= nil and self.bodyNode ~=nil then
		setVisibility(self.armNode, true);
		setVisibility(self.bodyNode, true);
	end;
end;

function FarmerArm:onLeave()
	if self.armNode ~= nil and self.bodyNode ~=nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.armNode, false);
			setVisibility(self.bodyNode, false);
		else
			setVisibility(self.armNode, true);
			setVisibility(self.bodyNode, true);
		end;
	end;
end;