--[[
BeaconLightFix

Script to allow import an beacon light directly in the i3d. Without this fix, the corona will stay invisibility!

@Author:	Ifko[nator]
@Date:		18.08.2017

@Version:	1.0 - initial release in FS 17
]]

BeaconLightFix = {};

function BeaconLightFix.prerequisitesPresent(specializations)
    return true; 
end;

function BeaconLightFix:load(savegame)
	local fixedBeaconLights = 0;
	
	while true do
		local beaconLightKey = "vehicle.beaconLights.beaconLight(" .. tostring(fixedBeaconLights) .. ")";
		
		if not hasXMLProperty(self.xmlFile, beaconLightKey) then
			break;
		end;
		
		local beaconLight = {};
		
		local decoration = Utils.indexToObject(self.components, getXMLString(self.xmlFile, beaconLightKey .. "#index"));
		local realLight = Utils.indexToObject(self.components, getXMLString(self.xmlFile, beaconLightKey .. "#realLight"));
		
		if decoration ~= nil then
			beaconLight.decoration = decoration;
		end;

		if realLight ~= nil then
			beaconLight.realLight = realLight;
			beaconLight.defaultColor = {getLightColor(beaconLight.realLight)};
			
			setVisibility(beaconLight.realLight, false);
		end;
		
		beaconLight.speed = Utils.getNoNil(getXMLFloat(self.xmlFile, beaconLightKey .. "#speed"), 0.02);
		
		table.insert(self.beaconLights, beaconLight);
	
		fixedBeaconLights = fixedBeaconLights + 1;
	end;
end;

function BeaconLightFix:update(dt)end;
function BeaconLightFix:delete()end;
function BeaconLightFix:mouseEvent(posX, posY, isDown, isUp, button)end;
function BeaconLightFix:keyEvent(unicode, sym, modifier, isDown)end;
function BeaconLightFix:draw()end;