--[[
	AllowDestroyGrassWithAnCultivator_Register.lua
	
	Autor: Ifko[nator]
	Datum: 09.08.2016
]]

SpecializationUtil.registerSpecialization("AllowDestroyGrassWithAnCultivator", "AllowDestroyGrassWithAnCultivator", g_currentModDirectory .. "AllowDestroyGrassWithAnCultivator.lua");

AllowDestroyGrassWithAnCultivator_Register = {};

function AllowDestroyGrassWithAnCultivator_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("cultivator") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location - 1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.AllowDestroyGrassWithAnCultivator", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.allowDestroyGrassWithAnCultivator", _name)) ~= nil
							then
								allowInsertion = false;
							end;
						end;
						
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("AllowDestroyGrassWithAnCultivator"));
							--print("installing 'AllowDestroyGrassWithAnCultivator' to: '" .. v_name_string .. "'.");
						end;
						
						Cultivator.ALLOW_DESTROY_GRASS = g_i18n:getText("ALLOW_DESTROY_GRASS");
						Cultivator.NOT_ALLOW_DESTROY_GRASS = g_i18n:getText("NOT_ALLOW_DESTROY_GRASS");
					end;
				end;
			end;	
		end;
	end;
end;

function AllowDestroyGrassWithAnCultivator_Register:deleteMap()end;
function AllowDestroyGrassWithAnCultivator_Register:keyEvent(unicode, sym, modifier, isDown)end;
function AllowDestroyGrassWithAnCultivator_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function AllowDestroyGrassWithAnCultivator_Register:update(dt)end;
function AllowDestroyGrassWithAnCultivator_Register:draw()end;

addModEventListener(AllowDestroyGrassWithAnCultivator_Register);