--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Adjust Working Speed
    Version: 1.1.0.0
    Date: March 2020
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
    
    Changelog Version 1.1.0.0:
    Attachments with <bundleElements> could no longer be called up in the store,
    this affected some forage harvester cutters from the Kemper pack. The affected
    cutterbars now no longer receive a configuration for adjustung the working speed,
    because the problem could not be solved otherwise.
]]

adjustWorkingSpeed = {}

local _modDirectory = g_currentModDirectory

function adjustWorkingSpeed.prerequisitesPresent(specializations)
    return true
end

function adjustWorkingSpeed.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", adjustWorkingSpeed)
end

function adjustWorkingSpeed:onLoad(savegame)
	
    local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName)
    if storeItem ~= nil and storeItem.configurations ~= nil then
        if storeItem.configurations["adjustWorkingSpeed"] ~= nil then

            local numSpeedLimit
            if storeItem.specs.speedLimit == nil then
                numSpeedLimit = 0
            elseif storeItem.specs.speedLimit == "" then
                numSpeedLimit = 0
            else
                numSpeedLimit = Utils.getNoNil(tonumber(storeItem.specs.speedLimit), 0)
            end
        
            if self.speedLimit ~= nil then
                if self.speedLimit > 0.5 then
                    if numSpeedLimit > 0.5 then
                        local configId = Utils.getNoNil(self.configurations["adjustWorkingSpeed"], 0)
                        if configId > 0.5 then
                            self.speedLimit = math.max(numSpeedLimit + configId - 8, 1)
                        end
                    end
                end
            end
            
        end
    end
end
